/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.weapon;

import dev.xkmc.curseofpandora.content.entity.WindBladeEntity;
import dev.xkmc.curseofpandora.content.entity.WindBladeWeapon;
import dev.xkmc.curseofpandora.content.sets.shadow.VoidOverflow;
import dev.xkmc.curseofpandora.content.weapon.EmptyClickListener;
import dev.xkmc.curseofpandora.content.weapon.WeaponTier;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPDamageTypeGen;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DoomStar
extends SwordItem
implements EmptyClickListener,
WindBladeWeapon {
    private static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.weapon.doomStarRealityIndex.get();
    }

    public DoomStar(Item.Properties props) {
        super((Tier)WeaponTier.DOOM_STAR, 10, -2.4f, props);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= DoomStar.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(DoomStar.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Weapon.DOOM_STAR.get(new Object[0]).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @Override
    public void clickEmpty(ItemStack stack, Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) < (double)DoomStar.getIndexReq()) {
            return;
        }
        float strength = player.m_36403_(0.5f);
        if (strength < 0.9f) {
            return;
        }
        player.m_36334_();
        Level level = player.m_9236_();
        float velocity = 3.0f;
        float dist = 64.0f;
        float dmg = (float)player.m_21133_(Attributes.f_22281_);
        float f = (float)(player.m_217043_().m_188500_() * 360.0);
        if (!level.m_5776_()) {
            WindBladeEntity e = new WindBladeEntity(level);
            e.m_5602_((Entity)player);
            e.m_6034_(player.m_20185_(), player.m_20188_() - 0.5, player.m_20189_());
            e.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity, 0.0f);
            e.setProperties(dmg, Math.round(dist / velocity), f, stack);
            level.m_7967_((Entity)e);
        }
    }

    @Override
    public DamageSource getSource(WindBladeEntity entity, @Nullable Entity owner) {
        Player player;
        ResourceKey<DamageType> type = owner instanceof Player && VoidOverflow.check(player = (Player)owner) ? CoPDamageTypeGen.VOID_CURSE : CoPDamageTypeGen.SHADOW_CURSE;
        return new DamageSource(CoPDamageTypeGen.forKey(entity.m_9236_(), type), (Entity)entity, owner);
    }

    @Override
    public ResourceLocation bladeTexture() {
        return new ResourceLocation("curseofpandora", "textures/entity/shadow_blade.png");
    }

    @Override
    public ParticleOptions getParticle() {
        return ParticleTypes.f_123799_;
    }
}

